@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/classificacoes-contas.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.planos-contas.index') }}">Planos de contas</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.planos-contas.edit', ['plano' => $plano]) }}">{{ $plano->nome }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Classificações</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Classificações
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @button([
                'route' => 'admin.planos-contas.classificacoes.create',
                'routeParams' => ['plano' => $plano],
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($classificacoes as $classificacao)
                        <tr>
                            <td>{{ $classificacao->nome }}</td>
                            <td>
                                @button([
                                'route' => 'admin.planos-contas.classificacoes.edit',
                                'routeParams' => ['plano' => $plano, 'classificacao' => $classificacao],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-classificacao',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.planos-contas.classificacoes.destroy',
                                'routeParams' => ['plano' => $plano, 'classificacao' => $classificacao],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-classificacao" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-classificacao">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o classificação?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection