@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/perguntas-anamnese/edit.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.perguntas-anamnese.index') }}">Perguntas da anamnese</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar pergunta
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.perguntas-anamnese.update', ['pergunta' => $pergunta]) }}" method="post">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-12">
                            <label for="descricao">Descrição *</label>
                            <input type="text" autofocus name="descricao" maxlength="150" class="form-control @error('descricao') is-invalid @enderror" value="{{ $pergunta->descricao }}">
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @if ($pergunta->trashed())
                    @button([
                    'icon' => 'refresh-ccw',
                    'label' => 'Restaurar',
                    'class' => 'btn-primary btn-restaurar-pergunta'
                    ])
                    @endbutton
                    @endif
                    @button([
                    'route' => 'admin.perguntas-anamnese.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-restaurar-pergunta" tabindex="-1" role="dialog">
    <form method="POST" id="form-restaurar-pergunta" action="{{ route('admin.perguntas-anamnese.restore', ['pergunta' => $pergunta])  }}">
        @csrf
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente restaurar a pergunta?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection