@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/niveis-salariais.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Niveis Salariais</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Niveis Salariais
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @button([
                'route' => 'admin.niveis-salariais.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Salário Base</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($niveis as $nivel)
                        <tr>
                            <td>{{ $nivel->nome }}</td>
                            <td>@if ($nivel->salario_base) {{ number_format($nivel->salario_base, 2, ',', '.') }} @endif</td>
                            <td>
                                @button([
                                'route' => 'admin.niveis-salariais.edit',
                                'routeParams' => ['nivel' => $nivel],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-nivel',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.niveis-salariais.destroy',
                                'routeParams' => ['nivel' => $nivel],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $niveis->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-nivel" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-nivel">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o nivel?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection