@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/motivos-cancelamentos-agendamentos.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Motivos de cancelamento de agendamento</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Motivos de cancelamento de agendamento
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @button([
                'route' => 'admin.motivos-cancelamentos-agendamentos.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Descrição</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($motivos as $motivo)
                        <tr>
                            <td>{{ $motivo->descricao }}</td>
                            <td>
                                @button([
                                'route' => 'admin.motivos-cancelamentos-agendamentos.edit',
                                'routeParams' => ['motivo' => $motivo],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-motivo',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.motivos-cancelamentos-agendamentos.destroy',
                                'routeParams' => ['motivo' => $motivo],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-motivo" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-motivo">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o motivo?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection