<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('app.name') }} - Desligamento sindicato</title>
    <link rel="stylesheet" href="{{ asset('css/admin/impressao.css') }}">
    <link rel="stylesheet" href="{{ asset('css/admin/impressos/formulario-desligamento-sindicato.css') }}">
</head>

<body onload="javascript:print()">
    <div id="wrapper">
        @component('components.impressos.cabecalho')@endcomponent

        <p class="cabecalho">
            À<br>
            DIRETORIA COLEGIADA<br>
            DD. Sindicato dos Servidores Públicos Municipais de Santos - SINDSERV
        </p>

        <h1>DESLIGAMENTO DO SINDICATO</h1>

        <p>
            Eu {{ $servidor->nome }}, registro funcional nº {{ $registro->numero }},

            @if ($servidor->eAposentado())
            lotato no IPREV,
            @else
            regime {{ $registro->regime }} lotado(a) na Secretaria {{ $secretaria }},
            @endif

            venho por meio deste solicitar o desligamento do quadro associativo
            desta entidade, e desautorizar a {{ $empresa }}, de proceder o desconto referente ao código
            ({{ $codigoMensalidade }} - Mensalidade Sindical).
        </p>
        <p>
            Esclareço ainda, que estou ciente que a partir desta desfiliação, cessam todos os direitos associativos,
            tais como: seguro de vida, atendimento jurídico, atendimento odontológico, convênios e outros.
        </p>
        <p class="aviso-prazo">
            A desfiliação que for realizada após o 1º dia útil sofrerá ainda o desconto da mensalidade no mês vigente.<br>
            A desautorização se dará após o devido recebimento do eventual débito junto a Entidade,
            que será feito pela {{ $empresa }}, condicionada ao sistema de desconto em folha de pagamento que funciona
            independente do SindServ.
        </p>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Associado
            </div>

            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Diretor
            </div>
        </div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Atendente
            </div>
        </div>

        <p class="data-recebimento">Recebemos pela Secretaria Geral ________/________/__________</p>

        @component('components.impressos.rodape')@endcomponent
    </div>
</body>

</html>
