<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('app.name') }} - Cancelamento seguro</title>
    <link rel="stylesheet" href="{{ asset('css/admin/impressao.css') }}">
    <link rel="stylesheet" href="{{ asset('css/admin/impressos/formulario-cancelamento-seguro.css') }}">
</head>

<body onload="javascript:print()">
    <div id="wrapper">
        @component('components.impressos.cabecalho')@endcomponent

        <div class="cabecalho">
            <div class="data">Santos, {{ today()->format('d/m/Y') }}</div>

            <p>
                À<br>
                DIRETORIA COLEGIADA<br>
                DD. Sindicato dos Servidores Públicos Municipais de Santos - SINDSERV
            </p>
        </div>

        <h1>CANCELAMENTO DO SEGURO</h1>

        <p>
            Eu {{ $servidor->nome }}, registro funcional nº {{ $registro->numero }}, regime {{ $registro->regime }} lotado(a) na
            Secretaria {{ $secretaria }}, venho por meio deste requerer o cancelamento do <b>SEGURO DE VIDA - código 407</b> e
            desautorizar a {{ $empresa }}, a continuar efetuando o referido desconto.
        </p>
        <p class="aviso-ressalva">
            <b>Ressalva:</b> pelo presente documento fica insento o <b>SINDSERV</b> de eventuais descontos cometido pela Prefeitura Municipal de Santos
            quanto a operacionalização deste desligamento do <b>SEGURO DE VIDA</b> após o envio do mesmo.
        </p>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Associado
            </div>

            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Diretor
            </div>
        </div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Atendente
            </div>
        </div>

        @component('components.impressos.rodape')@endcomponent
    </div>
</body>

</html>
