<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('app.name') }} - Cancelamento seguro</title>
    <link href="{{ asset('vendors/bootstrap/dist/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="{{ asset('css/admin/impressao.css') }}">
    <link rel="stylesheet" href="{{ asset('css/admin/impressos/formulario-cancelamento-osan-dependente.css') }}">
</head>

<body onload="javascript:print()">
    <div id="wrapper">
        @component('components.impressos.cabecalho')@endcomponent

        <h1>DESLIGAMENTO DE DEPENDENTES<br>CONVÊNIO OSAN/SINDSERV</h1>

        <p>
            Eu {{ $servidor->nome }}, registro funcional nº {{ $registro->numero }}, regime {{ $registro->regime }} autorizo o(a) {{ $empresa }},
            a baixa no valor de R$ __________, (___________________________________________________________________), a partir do mês ________________,
            que refere-se ao <b>desligamento</b> do dependente abaixo relacionado, no convênio OSAN/SINDSERV.
        </p>

        <table class="col-12">
            <thead>
                <tr>
                    <th>NOME DO DEPENDENTE</th>
                    <th>PARENTESCO</th>
                    <th>VALOR (R$)</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $dependente->nome }}</td>
                    <td>{{ $dependente->grau_parentesco->getValue() }}</td>
                    <td>&nbsp;</td>
                </tr>
            </tbody>
        </table>

        <div class="data-recebimento">Santos, {{ today()->format('d/m/Y') }}</div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Associado
            </div>

            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Diretor
            </div>
        </div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura Funcionário SINDSERV
            </div>
        </div>
    </div>
</body>

</html>
