<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('app.name') }} - Ficha de inscrição</title>
    <link href="{{ asset('vendors/bootstrap/dist/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="{{ asset('css/admin/impressos/ficha-inscricao.css') }}">
</head>

<body onload="javascript:print()">
    <div id="wrapper">
        @component('components.impressos.cabecalho')@endcomponent

        <h1>FICHA DE INSCRIÇÃO DO ASSOCIADO</h1>

        <div class="cabecalho form-row">
            <div class="col-8"><span class="label">Matrícula Sindical:</span> {{ $numeroMatricula }}</div>
            <div class="col-4"><span class="label">Data Admissão:</span> {{ optional($dataAdmissaoSindical)->format('d/m/Y') }}</div>
        </div>

        <div class="form-row">
            <div class="col-12"><span class="label">Nome:</span> {{ $servidor->nome }}</div>
        </div>
        <div class="form-row">
            <div class="col-6"><span class="label">Data de Nascimento:</span> {{ optional($servidor->data_nascimento)->format('d/m/Y') }}</div>
            <div class="col-6"><span class="label">Naturalidade/UF:</span> @if ($servidor->naturalidade) {{ $servidor->naturalidade }} / {{ $servidor->naturalidade_uf }} @endif</div>
        </div>
        <div class="form-row">
            <div class="col-6"><span class="label">Estado civil:</span> {{ $servidor->estado_civil }}</div>
            <div class="col-6"><span class="label">Filiação - Pai:</span> {{ $servidor->nome_pai }}</div>
        </div>
        <div class="form-row">
            <div class="col-6 offset-md-6"><span class="label">Mãe:</span> {{ $servidor->nome_mae }}</div>
        </div>
        <div class="form-row">
            <div class="col-3"><span class="label">RG:</span> {{ $servidor->rg }}</div>
            <div class="col-3"><span class="label">CPF:</span> {{ $servidor->cpf }}</div>
            <div class="col-6"><span class="label">Escolaridade:</span> {{ $servidor->nivel_ensino }}</div>
        </div>
        <div class="form-row">
            <div class="col-12"><span class="label">End. Residencial:</span>
                @if ($enderecoServidor)
                {{ $enderecoServidor->logradouro }},
                @if ($enderecoServidor->numero)
                {{ $enderecoServidor->numero }}.
                @else S/N
                @endif {{ optional($enderecoServidor)->complemento }}
                @endif
            </div>
        </div>
        <div class="form-row">
            <div class="col-4"><span class="label">Bairro:</span> {{ optional($enderecoServidor)->bairro }}</div>
            <div class="col-6"><span class="label">Cidade:</span> {{ optional($enderecoServidor)->cidade }} @if(isset($enderecoServidor->cidade)) - @endif {{ optional($enderecoServidor)->estado }}</div>
            <div class="col-2"><span class="label">CEP:</span> {{ optional($enderecoServidor)->cep }}</div>
        </div>
        <div class="form-row">
            <div class="col-6"><span class="label">Telefone Fixo:</span> {{ optional($telefoneFixo)->valor }}</div>
            <div class="col-6"><span class="label">Telefone Celular:</span> {{ optional($telefoneCelular)->valor }}</div>
        </div>
        <div class="form-row">
            <div class="col-12"><span class="label">E-mail:</span> {{ $email }}</div>
        </div>
        <div class="form-row">
            <div class="col-8"><span class="label">Secretaria:</span> {{ $secretaria }}</div>
            <div class="col-4"><span class="label">Data Admissão PMS:</span> {{ optional($registro->data_admissao)->format('d/m/Y') }}</div>
        </div>
        <div class="form-row">
            <div class="col-12"><span class="label">End. Local de trabalho:</span>
                @if ($enderecoLotacao)
                {{ $enderecoLotacao->logradouro }},
                @if ($enderecoLotacao->numero)
                {{ $enderecoLotacao->numero }}.
                @else S/N
                @endif
                {{ optional($enderecoLotacao)->complemento }}
                @endif
            </div>
        </div>
        <div class="form-row">
            <div class="col-4"><span class="label">Bairro:</span> {{ optional($enderecoLotacao)->bairro }}</div>
            <div class="col-6"><span class="label">Cidade:</span> {{ optional($enderecoLotacao)->cidade }} @if(isset($enderecoLotacao->cidade)) - @endif {{ optional($enderecoLotacao)->estado }}</div>
            <div class="col-2"><span class="label">CEP:</span> {{ optional($enderecoLotacao)->cep }}</div>
        </div>
        <div class="form-row">
            <div class="col-4"><span class="label">Registro Funcional:</span> {{ $registro->numero }}</div>
            <div class="col-4"><span class="label">Regime:</span> {{ $registro->regime }}</div>
            <div class="col-4"><span class="label">Setor:</span> {{ $nomeSetor }}</div>
        </div>
        <div class="form-row">
            <div class="col-4"><span class="label">Tel. Setor:</span> {{ $telefoneSetor }}</div>
            <div class="col-4"><span class="label">Nível Salarial:</span> {{ $nivelSalarial }}</div>
            <div class="col-4"><span class="label">Cargo:</span> {{ optional($cargo)->nome }}</div>
        </div>
        <div class="form-row">
            <div class="col-6"><span class="label">Readaptado?</span> {{ $registro->readaptado ? 'Sim' : 'Não' }}</div>
            <div class="col-6"><span class="label">Em qual função:</span> {{ optional($registro->cargo_readaptado)->nome }}</div>
        </div>
        <div class="form-row">
            <div class="col-6"><span class="label">Data aposentadoria:</span> {{ optional($registro->data_aposentadoria)->format('d/m/Y') }}</div>
            <div class="col-6">
                <label>CP <input type="checkbox" name="paridade" disabled value="CP" @if ($registro->data_aposentadoria && $registro->paridade) checked @endif></label>
                <label>NP <input type="checkbox" name="paridade" disabled value="NP" @if ($registro->data_aposentadoria && ! $registro->paridade) checked @endif></label>
            </div>
        </div>
        @if ($dependentes->count() > 0)
        <table class="col-12">
            <thead>
                <tr>
                    <th>Dependentes</th>
                    <th>Data de nascimento</th>
                    <th>Grau de parentesco</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($dependentes as $dependente)
                <tr>
                    <td>{{ $dependente->nome }}</td>
                    <td>{{ $dependente->data_nascimento->format('d/m/Y') }}</td>
                    <td>{{ $dependente->grau_parentesco->getValue() }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @endif

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Sócio Proponente
            </div>

            <div class="assinatura">
                ______________________________________<br>
                SINDSERV / SECRETARIA
            </div>
        </div>

        <div class="page-break"></div>

        @component('components.impressos.cabecalho')@endcomponent

        <h1>AUTORIZAÇÃO PARA DESCONTO</h1>
        <p>
            Eu, {{ $servidor->nome }}, Registro Nº {{ $registro->numero }}, Regime: {{ $registro->regime }},
            Secretaria: {{ $secretaria }}, pela presente, autorizo a {{ $empresa }} a descontar do meu SALÁRIO,
            mensalidades no valor R$ {{ $mensalidade ? number_format($mensalidade->valor, 2, ',', '.') : "0,00" }},
            ref. nível {{ $nivelSalarial }} do Sindicato dos Servidores
            Públicos Municipais de Santos, à partir do mês de {{ $mesDesconto }}.
        </p>
        <p>Tal desconto refere-se à mensalidade sindical.</p>
        <p class="mt-4">Santos, ___________ de _____________________ de 20__________</p>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                ASSINATURA
            </div>
        </div>
    </div>
</body>

</html>
