<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('app.name') }} - Anamnese</title>
    <link rel="stylesheet" href="{{ asset('vendors/bootstrap/dist/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/admin/impressao.css') }}">
    <link rel="stylesheet" href="{{ asset('css/admin/impressos/anamnese.css') }}">
</head>

<body onload="javascript:print()">
    <div id="wrapper">
        @component('components.impressos.cabecalho')@endcomponent

        <div class="cabecalho">
            <div class="data">Santos, {{ today()->format('d/m/Y') }}</div>
        </div>

        <h1>ANAMNESE</h1>

        <div class="form-row">
            <div class="col-2"><b>Nome</b></div>
            <div class="col">{{ $agendavel->nome }}</div>
        </div>
        <div class="form-row">
            <div class="col-2"><b>Data de nasc.</b></div>
            <div class="col">{{ optional($agendavel->data_nascimento)->format('d/m/Y') }}</div>
        </div>

        <div class="form-row mt-4">
            <table class="col-12">
                <thead>
                    <tr>
                        <th class="w-50">Pergunta</th>
                        <th>Sim/Não</th>
                        <th>Qual?</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($perguntas as $pergunta)
                        @php
                            $respostaPergunta = $respostas->where('pergunta_anamnese_id', $pergunta->id)->first();
                        @endphp
                        <tr>
                            <td>{{ $pergunta->descricao }}</td>
                            <td>
                                @if ($respostaPergunta) X @endif
                            </td>
                            <td>
                                {{ optional($respostaPergunta)->qual}}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do {{ $agendavel->tipoFormatado() }}
            </div>
        </div>
    </div>
</body>

</html>