@extends('layouts.admin')

@push('css')
<link href="{{ asset('vendors/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('vendors/select2/dist/js/select2.full.min.js') }}"></script>
<script src="{{ asset('js/admin/guia-atendimento/index.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Guia de atendimento</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Guia de atendimento
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <input type="hidden" id="hidden-route-busca" value="{{ route('admin.guia-atendimento.busca-servidor') }}">

                <form action="">
                    <div class="form-row">
                        <div class="form-group col-5">
                            <select name="servidor" id="select-servidor" class="form-control @error('servidor') is-invalid @enderror"></select>
                        </div>
                        <div class="form-group col-2">
                            <select name="resolvido" class="form-control">
                                <option value="1">Resolvido</option>
                                <option value="0">Não resolvido</option>
                                <option value="">Todos</option>
                            </select>
                        </div>

                        <div class="col">
                            <button class="btn btn-primary" type="submit"><i data-feather="search"></i> Buscar</button>
                        </div>
                    </div>
                </form>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Servidor</th>
                            <th>Resolvido</th>
                            <th>Motivo</th>
                            <th>Atendente</th>
                            <th>Data</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($atendimentos as $atendimento)
                        <tr>
                            <td>{{ $atendimento->servidor->nome }}</td>
                            <td>{{ $atendimento->resolvido ? 'SIM' : 'NÃO' }}</td>
                            <td>{{ optional($atendimento->motivo)->descricao }}</td>
                            <td>{{ $atendimento->usuario->name }}</td>
                            <td>{{ $atendimento->created_at->format('d/m/Y H:i:s') }}</td>
                            <td>
                                @button([
                                'route' => 'admin.guia-atendimento.edit',
                                'routeParams' => ['atendimento' => $atendimento],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $atendimentos->links() }}
            </section>
        </div>
    </div>
</div>
@endsection