<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('app.name') }} - Geração carteirinha</title>
    <link rel="stylesheet" href="{{ asset('css/admin/geracao-carteirinha.css') }}">
</head>

<body>
    <div id="wrapper">
        @foreach ($servidores as $servidor)
        @php
        $registro = $servidor->registros()->ativos()->first();
        $matricula = $servidor->matriculas()->ativa()->first();
        $unidade = optional($registro)->unidadeOrganizacional;
        if ($unidade) {
        $secretaria = optional($unidade->secretaria())->sigla_nome;
        } else {
        $secretaria = '';
        }
        @endphp
        <div class="carteirinha">
            <div class="frente">
                <div class="header">
                    <div class="logo">
                        <img src="{{ asset('images/logo-pequeno.png') }}">
                    </div>
                    <div class="titulo">
                        Sindicato dos Servidores Públicos Municipais de Santos
                    </div>
                </div>
                <div class="dados">
                    <div class="campos">
                        <div class="linha">
                            <span class="campo">Nome:</span>
                            <span class="valor">{{ $servidor->nome_exibir }}</span>
                        </div>
                        <div class="linha">
                            <span class="campo">Reg. nº:</span>
                            <span class="valor">{{ $registro->numero }}</span>
                        </div>
                        <div class="linha">
                            <span class="campo campo-grande">Data adm. PMS:</span>
                            <span class="valor">{{ optional($registro->data_admissao)->format('d/m/Y') }}</span>
                        </div>
                    </div>
                    <div class="foto">
                        @if ($servidor->imagem)
                        <img src='{{ asset("storage/servidores/miniaturas/{$servidor->imagem}") }}'>
                        @endif
                    </div>
                </div>
            </div>
            <div class="verso">
                <div class="linha">
                    <div class="coluna">
                        <span class="campo">Matr. Sind.:</span>
                        <span class="valor">{{ str_pad($matricula->id, 6, 0, STR_PAD_LEFT) }}</span>
                    </div>
                    <div class="coluna">
                        <span class="campo">Data adm. Sind.:</span>
                        <span class="valor">{{ $matricula->created_at->format('d/m/Y') }}</span>
                    </div>
                </div>
                <div class="linha">
                    <span class="campo">Secretaria:</span>
                    <span class="valor">{{ $secretaria }}</span>
                </div>
                <div class="linha">
                    <span class="campo">Cargo:</span>
                    <span class="valor">{{ optional($registro->cargo)->nome }}</span>
                </div>
                <div class="rodape">
                    Válido com a apresentação do último holerite e RG
                </div>
            </div>
        </div>
        @if ($loop->iteration % 4 == 0)
        <div class="pagebreak"> </div>
        @endif
        @endforeach
    </div>
</body>

</html>
