@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/funcionarios/index.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Funcionários</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Funcionários
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts
                
                @button([
                'route' => 'admin.funcionarios.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                @busca([
                'route' => 'admin.funcionarios.index',
                'busca' => $termo ?? null
                ])
                @endbusca

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Função</th>
                            <th>Telefone(s)</th>
                            <th>Acessa sistema</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($funcionarios as $funcionario)
                        <tr>
                            <td>{{ $funcionario->nome }}</td>
                            <td>{{ $funcionario->funcao }}</td>
                            <td>{{ implode(' ', $funcionario->contatos()->telefones()->take(2)->get()->pluck('valor')->toArray()) }}</td>
                            <td>{{ $funcionario->temUsuario() ? 'SIM' : 'NÃO'}}</td>
                            <td>
                                @button([
                                'route' => 'admin.funcionarios.edit',
                                'routeParams' => ['funcionario' => $funcionario],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-funcionario',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.funcionarios.destroy',
                                'routeParams' => ['funcionario' => $funcionario],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $funcionarios->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-funcionario" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-funcionario">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o funcionário?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection