@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/exportacao-csv/index.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Exportação de CSV</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Exportação de CSV
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <div class="alert alert-info" role="alert">
                    <b>Atenção: </b>Selecione codificação UTF-8 e separador por vírgula no seu software de planilhas.
                </div>
                <form method="POST" action="{{ route('admin.exportacao-csv.exporta') }}">
                    @csrf

                    <div class="form-row">
                        <h5>Filtro</h5>
                        <hr class="col-12">

                        <div class="form-group col-3">
                            <label for="filtroAtivoAposentado">Ativo/Aposentado</label>
                            <select name="filtroAtivoAposentado" class="form-control">
                                @foreach ($filtrosAtivosAposentados as $filtroAtivoAposentado)
                                <option value="{{ $filtroAtivoAposentado->getIndex() }}">{{ $filtroAtivoAposentado->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="filtroSituacao">Situação sindical</label>
                            <select name="filtroSituacao" class="form-control">
                                @foreach ($filtrosSituacao as $filtroSituacao)
                                <option value="{{ $filtroSituacao->getIndex() }}">{{ $filtroSituacao->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-row">
                        <h5>Colunas</h5>
                        <hr class="col-12">
                    </div>
                    <div id="div-colunas" class="form-row col-12">
                        <div class="form-group col-3 coluna">
                            <select name="colunas[]" class="form-control">
                                @foreach ($colunas as $coluna)
                                <option value="{{ $coluna->getIndex() }}">{{ $coluna->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <hr>

                    <button id="btn-inclui-coluna" class="btn btn-primary" type="button"><i data-feather="plus"></i> Incluir coluna</button>
                    <button class="btn btn-primary" type="submit"><i data-feather="file-text"></i> Exportar</button>
                </form>
            </section>
        </div>
    </div>
</div>
@endsection
