@extends('layouts.admin')

@push('js')
<script src="https://cdn.ckeditor.com/ckeditor5/12.3.1/classic/ckeditor.js"></script>
<script src="https://cdn.ckeditor.com/ckeditor5/12.3.1/classic/translations/pt.js"></script>
<script src="{{ asset('js/admin/lotemensagens/show.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.comunicacao-sms.mensagens-enviadas') }}">Envio de SMS</a></li>
        <li class="breadcrumb-item active" aria-current="page">Exibição de mensagem</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Mensagem "{{ str_limit($mensagem->assunto, 50) }}"
        </h4>
    </div>
    <!-- /Title -->

    <div class="col-xl-12">
        <section class="hk-sec-wrapper">
            <div class="form-row">
                <div class="form-group col-12">
                    <label for="assunto">Assunto</label>
                    <input type="text" readonly name="assunto" class="form-control" value="{{ $mensagem->assunto }}">
                </div>
                <div class="form-group col-12">
                    <label for="corpo">Assunto</label>
                    <textarea type="text" id="text-corpo" readonly name="corpo" class="form-control">{{ $mensagem->corpo }}</textarea>
                </div>
                <div class="form-group col-md-4 col-12">
                    <label for="metodo">Enviada como</label>
                    <select class="form-control" name="metodo" disabled>
                        @foreach ($metodos as $metodo)
                        <option value="{{ $metodo }}" {{ $lotemensagen->metodo == $metodo ? 'selected' : '' }}>{{ ucfirst($metodo) }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-6">
                    <label for="assunto">Enviada em</label>
                    <input type="text" readonly name="created_at" class="form-control-plaintext" value="{{ $lotemensagen->created_at->format('d/m/Y H:i:s') }}">
                </div>
            </div>
        </section>
        <section class="hk-sec-wrapper">
            <h5 class="hk-sec-title">Destinatários</h5>

            <table class="table mt-3">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>E-mail</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($mensagens as $m)
                    <tr>
                        </td>
                        <td>{{ $m->condomino->nome_fantasia ? str_limit($m->condomino->nome_fantasia, 50) : str_limit($m->condomino->nome, 50) }}</td>
                        <td>{{ str_limit($m->condomino->email, 50) }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            <hr>
            @button([
            'route' => 'admin.lotemensagens.index',
            'icon' => 'arrow-left',
            'label' => 'Voltar',
            'class' => 'btn-secondary'
            ])
            @endbutton
        </section>
    </div>
</div>
@endsection