@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/envio-sms/mensagens-enviadas.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Envio de SMS</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Envio de SMS
        </h4>
    </div>
    <!-- /Title -->

    @alerts
    @endalerts
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @button([
                'route' => 'admin.envio-sms.selecao-contatos-form',
                'icon' => 'plus',
                'label' => 'Escrever',
                'class' => 'btn-primary'
                ])
                @endbutton

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Mensagem</th>
                            <th>Enviada em</th>
                            <th>Por</th>
                            <th>Qtde. servidores</th>
                            <th>Filtro utilizado</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($mensagens as $mensagem)
                        <tr>
                            <td>{{ str_limit($mensagem->mensagem, 50) }}</td>
                            <td>{{ $mensagem->created_at->format('d/m/Y H:i:s') }}</td>
                            <td>{{ $mensagem->enviado_por->name }}</td>
                            <td>{{ $mensagem->qtde_contatos }}</td>
                            <td>{{ $mensagem->tipo_servidor }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
@endsection