@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.envio-sms.mensagens-enviadas') }}">Envio de SMS</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.envio-sms.selecao-contatos-form') }}">Seleção de contatos</a></li>
        <li class="breadcrumb-item active" aria-current="page">Escrever mensagem</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Escreva a mensagem a ser enviada
        </h4>
    </div>
    <!-- /Title -->

    <div class="col-xl-12">
        <section class="hk-sec-wrapper">
            <form action="{{ route('admin.envio-sms.armazena-mensagem') }}" method="post">
                @csrf
                @alerts
                @endalerts

                <div class="form-row">
                    <div class="form-group col-12">
                        <label for="mensagem">Mensagem</label>
                        <textarea required rows="5" name="mensagem" class="form-control @error('mensagem') is-invalid @enderror" value="{{ old('mensagem') }}" value="{{ old('mensagem') }}"></textarea>
                    </div>
                </div>
                <hr>
                @button([
                'icon' => 'arrow-right',
                'label' => 'Avançar',
                'class' => 'btn-primary'
                ])
                @endbutton
                @button([
                'route' => 'admin.envio-sms.selecao-contatos-form',
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ])
                @endbutton
            </form>
        </section>
    </div>
</div>
@endsection