@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['enderecavel']['index']['route']) }}">{{ $enderecavel }}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['enderecavel']['edit']['route'], $routes['enderecavel']['edit']['params']) }}">Editar</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar endereço</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar endereço
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route($routes['endereco']['update']['route'], $routes['endereco']['update']['params']) }}" method="post">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    @include('components.endereco', ['obrigatorio' => true, 'container' => 'form-row', 'malaDireta' => true,
                                                     'malaDiretaChecked' => old('aceita_mala_direta', $endereco->aceita_mala_direta) ? true : false])

                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => $routes['enderecavel']['edit']['route'],
                    'routeParams' => $routes['enderecavel']['edit']['params'],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection