@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/funcionarios/create-edit.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['dependido']['index']['route']) }}">{{ $dependido }}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['dependido']['edit']['route'], $routes['dependido']['edit']['params']) }}">{{ $routes['dependido']['nome'] }}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['dependente']['index']['route'], $routes['dependente']['index']['params']) }}">Dependentes</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ $dependente->nome }}</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar dependente
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route($routes['dependente']['update']['route'], $routes['dependente']['update']['params']) }}" method="post">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="nome">Nome *</label>
                            <input type="text" required autofocus name="nome" maxlength="150" class="form-control @error('nome') is-invalid @enderror" value="{{ old('nome') ?? $dependente->nome }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="grau_parentesco">Grau de parentesco *</label>
                            <select name="grau_parentesco" required class="form-control @error('grau_parentesco') is-invalid @enderror">
                                @foreach ($graus as $grau)
                                <option value="{{ $grau->getIndex() }}" {{ $dependente->grau_parentesco->isEqual($grau) ? 'selected' : ''}}>{{ $grau->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="data_nascimento">Data de nascimento *</label>
                            <input type="text" required name="data_nascimento" class="data form-control data_nascimento @error('data_nascimento') is-invalid @enderror" value="{{ old('data_nascimento') ?? $dependente->data_nascimento->format('d/m/Y') }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="sexo">Sexo *</label>
                            <select name="sexo" required class="form-control @error('sexo') is-invalid @enderror">
                                @foreach ($sexos as $sexo)
                                <option value="{{ $sexo->getIndex() }}" {{ $dependente->sexo->isEqual($sexo) ? 'selected' : '' }}>{{ $sexo->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="data_admissao">Data de admissão *</label>
                            <input type="text" required name="data_admissao" class="data form-control @error('data_admissao') is-invalid @enderror" value="{{ old('data_admissao') ?? $dependente->data_admissao->format('d/m/Y') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="ativo">Ativo *</label>
                            <select name="ativo" required class="form-control @error('ativo') is-invalid @enderror">
                                <option value="1" {{ $dependente->ativo ? 'selected' : '' }}>SIM</option>
                                <option value="0" {{ ! $dependente->ativo ? 'selected' : '' }}>NÃO</option>
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="especial">Especial *</label>
                            <select name="especial" required class="form-control @error('especial') is-invalid @enderror">
                                <option value="0" {{ ! $dependente->especial ? 'selected' : '' }}>NÃO</option>
                                <option value="1" {{ $dependente->especial ? 'selected' : '' }}>SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="falecido">Falecido *</label>
                            <select name="falecido" required class="form-control @error('falecido') is-invalid @enderror">
                                <option value="0" {{ ! $dependente->falecido ? 'selected' : '' }}>NÃO</option>
                                <option value="1" {{ $dependente->falecido ? 'selected' : '' }}>SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea type="text" name="observacoes" maxlength="1000" rows="5" class="form-control @error('observacoes') is-invalid @enderror">{{ old('observacoes') ?? $dependente->observacoes }}</textarea>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => $routes['convenio']['index']['route'],
                    'routeParams' => $routes['convenio']['index']['params'],
                    'icon' => 'list',
                    'label' => 'Convênios',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @button([
                    'route' => $routes['dependente']['index']['route'],
                    'routeParams' => $routes['dependente']['index']['params'],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection