@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page"><a href="{{ route('admin.dependentes.busca') }}">Dependentes</a></li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Dependentes
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <form id="filtro">
                    <div class="form-row">
                        <div class="input-group col-4 offset-md-8">
                            <input type="text" autocomplete="off" value="{{ $busca ?? '' }}" name="busca" class="form-control busca @error('busca') is-invalid @enderror">
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-outline-secondary" title="Buscar"><i data-feather="search"></i></button>
                                <a href="{{ route('admin.dependentes.busca') }}" class="btn btn-outline-secondary" title="Limpar"><i data-feather="x"></i></a>
                            </div>
                        </div>
                    </div>
                </form>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Titular</th>
                            <th>Tipo</th>
                            <th>Grau</th>
                            <th>Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($dependentes as $dependente)
                        <tr>
                            <td>{{ $dependente->nome }}</td>
                            <td>{{ $dependente->dependivel->nome }}</td>
                            <td>{{ ucfirst($dependente->dependivel->tipoFormatado()) }}</td>
                            <td>{{ $dependente->grau_parentesco->getValue() }}</td>
                            <td>
                                @if ($dependente->dependivel->tipo() == 'associado')
                                    @button([
                                        'route' => 'admin.servidores.edit',
                                        'routeParams' => ['servidor' => $dependente->dependivel_id],
                                        'class' => 'btn-primary',
                                        'label' => 'Abrir titular',
                                        'icon' => 'edit'
                                        ])
                                    @endbutton
                                    @button([
                                        'route' => 'admin.servidores.dependentes.edit',
                                        'routeParams' => ['servidor' => $dependente->dependivel_id, 'dependente' => $dependente->id],
                                        'class' => 'btn-primary',
                                        'label' => 'Abrir dependente',
                                        'icon' => 'edit'
                                        ])
                                    @endbutton
                                @else
                                    @button([
                                        'route' => 'admin.funcionarios.edit',
                                        'routeParams' => ['funcionario' => $dependente->dependivel_id],
                                        'class' => 'btn-primary',
                                        'label' => 'Abrir principal',
                                        'icon' => 'edit'
                                        ])
                                    @endbutton
                                    @button([
                                        'route' => 'admin.funcionarios.dependentes.edit',
                                        'routeParams' => ['funcionario' => $dependente->dependivel_id, 'dependente' => $dependente->id],
                                        'class' => 'btn-primary',
                                        'label' => 'Abrir dependente',
                                        'icon' => 'edit'
                                        ])
                                    @endbutton
                                @endif
                                
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $dependentes->links() }}
            </section>
        </div>
    </div>
</div>
@endsection
