@extends('layouts.admin')

@push('css')
<link href="{{ asset('vendors/daterangepicker/daterangepicker.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('vendors/moment/min/moment-with-locales.min.js') }}"></script>
<script src="{{ asset('vendors/daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('js/admin/contas-pagar-receber/index.js') }}"></script>
@endpush


@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Contas a pagar e receber</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Contas a pagar e receber
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <div class="form-row">
                    <div class="col-6">
                        @button([
                        'route' => 'admin.contas-pagar.create',
                        'icon' => 'plus',
                        'label' => 'Incluir Saída',
                        'class' => 'btn-primary'
                        ])
                        @endbutton
                        @button([
                        'route' => 'admin.contas-receber.create',
                        'icon' => 'plus',
                        'label' => 'Incluir Entrada',
                        'class' => 'btn-primary mx-2'
                        ])
                        @endbutton
                    </div>
                    <div class="col">
                        <div class="form-inline float-right mx-2">
                            <label for="busca" class="mr-1">Busca</label>
                            <input form="filtro" type="text" name="busca" value="{{ request()->busca }}" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-10 offset-md-2">
                        <div class="form-inline float-right mx-2">
                            <button class="btn btn-outline-primary" type="submit" form="filtro">Filtrar</button>
                            <button id="btn-limpar" class="btn btn-outline-secondary mx-1" type="button" form="filtro">Limpar</button>
                        </div>
                        <div class="btn-group btn-group-toggle float-right" data-toggle="buttons">
                            @foreach ($statuses as $status)
                                @php
                                    $enabled = $status->isEqual($filtroStatus);
                                    $checked = $enabled ? 'checked' : '';
                                    $active = $enabled ? 'active' : '';
                                @endphp
                                <label class="btn btn-outline-secondary {{ $active }}">
                                    <input class="status" form="filtro" name="status" value="{{ $status->getIndex() }}" type="radio" {{ $checked }}> {{ $status }}
                                </label>
                            @endforeach
                        </div>
                        <div class="form-inline float-right mx-2">
                            <label for="vencimento" class="mr-1">Vencimento</label>
                            <input type="text" form="filtro" autocomplete="off" value="{{ $vencimento }}" name="vencimento" class="form-control vencimento @error('vencimento') is-invalid @enderror" value="{{ old('vencimento') }}">
                        </div>
                    </div>
                </div>
                <form id="filtro">
                </form>

                <table class="table table-sm mt-3">
                    <thead>
                        <tr>
                            <th>Tipo</th>
                            <th>Descrição</th>
                            <th>Status</th>
                            <th>Tipo despesa</th>
                            <th>Data venc.</th>
                            <th>Valor (R$)</th>
                            <th>Doc. Pendente</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($contas as $conta)
                        <tr>
                            <td>{{ optional($conta->tipo)->getValue() }}</td>
                            <td>
                                <div class="row">{{ $conta->descricao }}</div>
                                <div class="row"><span style="font-size: 0.7em">{{ $conta->observacoes }}</span></div>
                            </td>
                            <td>{{ $conta->status->getValue() }}</td>
                            <td>{{ optional($conta->tipo_despesa)->getValue() }}</td>
                            <td>{{ $conta->vencimento->format('d/m/Y') }}</td>
                            <td>{{ number_format($conta->valor, 2, ',', '.') }}</td>
                            <td>@if ($conta->caminho_documento) Não @else Sim @endif</td>
                            <td>
                                @if ($conta->tipo->isEntrada())
                                    @button([
                                    'route' => 'admin.contas-receber.edit',
                                    'routeParams' => ['conta' => $conta],
                                    'class' => 'btn-primary',
                                    'label' => 'Visualizar/Editar',
                                    'icon' => 'edit'
                                    ])
                                    @endbutton
                                @else
                                    @button([
                                    'route' => 'admin.contas-pagar.edit',
                                    'routeParams' => ['conta' => $conta],
                                    'class' => 'btn-primary',
                                    'label' => 'Visualizar/Editar',
                                    'icon' => 'edit'
                                    ])
                                    @endbutton
                                @endif
                                @button([
                                'class' => 'btn-danger btn-excluir-conta',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.contas-pagar-receber.destroy',
                                'routeParams' => ['conta' => $conta],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $contas->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-conta" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-conta">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir a conta?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection