@extends('layouts.admin')

@push('css')
<link href="{{ asset('vendors/daterangepicker/daterangepicker.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('vendors/moment/min/moment-with-locales.min.js') }}"></script>
<script src="{{ asset('vendors/daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('js/admin/contas-pagar-receber/create-receber-edit.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.contas-pagar-receber.index') }}">Contas a pagar e receber</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar entrada</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar entrada
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.contas-receber.update', ['conta' => $conta]) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <input type="hidden" id="url-api-classificacoes" value="{{ url('api/plano-contas') }}">
                    <input type="hidden" id="hidden-classificacao-selecionada" value="{{ old('classificacao_conta_id', $conta->classificacao_conta_id) }}">

                    <div class="form-row">
                        <div class="form-group col-3">
                            <label for="forma_recebimento">Forma *</label>
                            <select autofocus name="forma_recebimento" id="select-forma-recebimento" class="form-control @error('forma_recebimento') is-invalid @enderror">
                                @foreach ($formasRecebimento as $formaRecebimento)
                                <option value="{{ $formaRecebimento->getIndex() }}" @if (old('forma_recebimento', optional($conta->forma_recebimento)->getIndex())==$formaRecebimento->getIndex()) selected @endif>{{ $formaRecebimento->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-4" id="div-numero-documento">
                            <label for="numero_documento">Número cheque *</label>
                            <input type="text" name="numero_documento" maxlength="255" class="form-control @error('numero_documento') is-invalid @enderror" value="{{ old('numero_documento', $conta->numero_documento) }}">
                        </div>
                        <div class="form-group col-5">
                            <label for="descricao">Descrição *</label>
                            <input required type="text" name="descricao" maxlength="255" class="form-control @error('descricao') is-invalid @enderror" value="{{ old('descricao', $conta->descricao) }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="status">Status *</label>
                            <select id="select-status" name="status" class="form-control @error('valor') is-invalid @enderror">
                                @foreach ($statuses as $status)
                                <option value="{{ $status->getIndex() }}" @if (old('status', $conta->status->getIndex())==$status->getIndex()) selected @endif>{{ $status->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="data_pagamento">Data *</label>
                            <input type="text" required name="data_pagamento" maxlength="10" class="form-control data @error('data_pagamento') is-invalid @enderror" value="{{ old('data_pagamento', optional($conta->data_pagamento)->format('d/m/Y')) }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="valor_pago">Valor *</label>
                            <input type="text" required id="text-valor-pago" name="valor_pago" maxlength="10" class="form-control dinheiro @error('valor_pago') is-invalid @enderror" value="{{ old('valor_pago', $conta->valor_pago) }}">
                        </div>
                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea maxlength="255" class="form-control" name="observacoes" rows="3">{{ old('observacoes', $conta->observacoes) }}</textarea>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.contas-pagar-receber.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection
