@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/configuracoes.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Configuração</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Configuração
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts
                <div class="alert alert-info" role="alert">
                    Apenas usuários com perfil de super-usuário podem incluir e excluir configurações.
                </div>

                @role('superuser')
                @button([
                'route' => 'admin.configuracoes.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton
                @endrole

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Categoria</th>
                            <th>Nome</th>
                            <th>Valor</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($configuracoes as $configuracao)
                        <tr>
                            <td>{{ $configuracao->categoria->getValue() }}</td>
                            <td>{{ $configuracao->nome }}</td>
                            <td>{{ $configuracao->valor }}</td>
                            <td>
                                @button([
                                'route' => 'admin.configuracoes.edit',
                                'routeParams' => ['configuracao' => $configuracao],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @role('superuser')
                                @button([
                                'class' => 'btn-danger btn-excluir-configuracao',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.configuracoes.destroy',
                                'routeParams' => ['configuracao' => $configuracao],
                                ])
                                @endbutton
                                @endrole
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-configuracao" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-configuracao">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir a configuração?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection
