@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.configuracoes.index') }}">Configuração</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar configuração
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.configuracoes.update', ['configuracao' => $configuracao]) }}" method="post">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <div class="alert alert-warning" role="alert">
                        <b>Atenção:</b> A alteração do nome de uma configuração acarretará no mal-funcionamento do sistema.
                    </div>
                    <div class="form-row">
                        <div class="form-group col-3">
                            <label for="categoria">Categoria *</label>
                            <select name="categoria" class="form-control @error('categoria') is-invalid @enderror" value="{{ old('categoria') }}">
                                @foreach ($categorias as $categoria)
                                <option value="{{ $categoria->getName() }}" @if ($categoria->getName() == $configuracao->categoria->getName()) selected @endif>{{ $categoria->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-4">
                            <label for="nome">Nome *</label>
                            <input type="text" name="nome" required maxlength="100" class="form-control @error('nome') is-invalid @enderror" value="{{ old('nome', $configuracao->nome) }}">
                        </div>
                        <div class="form-group col-5">
                            <label for="valor">Valor *</label>
                            <input type="text" name="valor" required maxlength="100" class="form-control @error('valor') is-invalid @enderror" value="{{ old('valor', $configuracao->valor) }}">
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'class' => 'btn-danger btn-excluir',
                    'icon' => 'x',
                    'label' => 'Excluir',
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.configuracoes.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir" tabindex="-1" role="dialog">
    <form method="POST" action="{{ route('admin.configuracoes.destroy', ['configuracao' => $configuracao]) }}">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o configuração?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection
