@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.configuracoes.index') }}">Configurações</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir configuração
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.configuracoes.store') }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-3">
                            <label for="categoria">Categoria *</label>
                            <select name="categoria" class="form-control @error('categoria') is-invalid @enderror" value="{{ old('categoria') }}">
                                @foreach ($categorias as $categoria)
                                <option value="{{ $categoria->getName() }}">{{ $categoria->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-4">
                            <label for="nome">Nome *</label>
                            <input type="text" name="nome" required maxlength="100" class="form-control @error('nome') is-invalid @enderror" value="{{ old('nome') }}">
                        </div>
                        <div class="form-group col-5">
                            <label for="valor">Valor *</label>
                            <input type="text" name="valor" required maxlength="100" class="form-control @error('valor') is-invalid @enderror" value="{{ old('valor') }}">
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.configuracoes.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection
