@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.atendimentos-odontologicos.index') }}">Atendimentos odontológicos</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'ODONTOLOGICO']) }}">Agenda</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.atendimentos-odontologicos.create', ['agendamento' => $agendamento]) }}">Atender</a></li>
        <li class="breadcrumb-item active" aria-current="page">Informações do paciente</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Informações do paciente
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <div class="form-row">
                    <div class="form-group col-6">
                        <label for="nome">Nome</label>
                        <input type="text" name="nome" readonly class="form-control-plaintext" value="{{ $paciente->nome }}">
                    </div>
                    <div class="form-group col-3">
                        <label for="data_nascimento">Data de nascimento</label>
                        <input type="text" name="data_nascimento" readonly class="form-control-plaintext" value="{{ $paciente->data_nascimento->format('d/m/Y') }}">
                    </div>
                    <div class="form-group col-2">
                        <label for="idade">Idade</label>
                        <input type="text" name="idade" readonly class="form-control-plaintext" value="{{ $paciente->data_nascimento->diffInYears(Carbon\Carbon::today()) }}">
                    </div>
                    <div class="form-group col-3">
                        <label for="sexo">Sexo</label>
                        <input type="text" name="sexo" readonly class="form-control-plaintext" value="{{ $paciente->sexo }}">
                    </div>
                    @if ($paciente instanceof App\Models\Servidor)
                    <div class="form-group col-3">
                        <label for="nacionalidade">Nacionalidade</label>
                        <input type="text" name="nacionalidade" readonly class="form-control-plaintext" value="{{ $paciente->nacionalidade }}">
                    </div>
                    <div class="form-group col-3">
                        <label for="naturalidade">Naturalidade</label>
                        <input type="text" name="naturalidade" readonly class="form-control-plaintext" value="{{ $paciente->naturalidade }}">
                    </div>
                    <div class="form-group col-5">
                        <label for="cargo">Cargos</label>
                        <input type="text" name="cargo" readonly class="form-control-plaintext" value="{{ implode(', ', $paciente->registros()->ativos()->get()->pluck('cargo.nome')->toArray()) }}">
                    </div>
                    @endif
                </div>
                <hr>
                @button([
                'route' => 'admin.atendimentos-odontologicos.create',
                'routeParams' => ['agendamento' => $agendamento],
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ])
                @endbutton
            </section>
        </div>
    </div>
</div>
@endsection