@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO']) }}">Atendimento Jurídico</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.show', ['agendamento' => $agendamento]) }}">Agendamento</a></li>
        @if ($agendamento->agendavel->tipo() == 'associado')
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $agendamento->agendavel]) }}">{{ $agendamento->agendavel->nome }}</a></li>
        @else
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.funcionarios.edit', ['funcionario' => $agendamento->agendavel]) }}">{{ $agendamento->agendavel->nome }}</a></li>
        @endif
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar atendimento
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.atendimentos-juridicos.update', ['agendamento' => $agendamento, 'processo' => $processo, 'atendimento' => $atendimento]) }}" method="post">
                    @csrf
                    @method('PUT')
                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-4">
                            <label for="horario">Horário agendamento</label>
                            <input type="text" readonly class="form-control-plaintext" value="{{ $atendimento->agendamento->inicio->format('d/m/Y - H:i') }} às {{ $atendimento->agendamento->fim->format('H:i') }}">
                        </div>
                        <div class="form-group col-12">
                            <label for="anotacoes">Anotações</label>
                            <textarea autofocus required class="form-control" rows="8" name="anotacoes">{{ old('anotacoes') ?? $atendimento->anotacoes }}</textarea>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @if ($agendamento->agendavel->tipo() == 'associado')
                    @button([
                    'route' => 'admin.servidores.edit',
                    'routeParams' => ['servidor' => $agendamento->agendavel],
                    'icon' => 'arrow-left',
                    'label' => 'Associado',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @else
                    @button([
                    'route' => 'admin.funcionarios.edit',
                    'routeParams' => ['funcionario' => $agendamento->agendavel],
                    'icon' => 'arrow-left',
                    'label' => 'Funcionário',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @endif

                    @button([
                    'route' => 'admin.processos-juridicos.edit',
                    'routeParams' => ['pessoa' => $agendamento->agendavel, 'tipo' => $agendamento->agendavel->tipo(), 'id' => $processo],
                    'icon' => 'arrow-left',
                    'label' => 'Processo Jurídico',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection