@extends('layouts.admin')

@push('js')
<script src="{{ asset('vendors/moment/min/moment-with-locales.min.js') }}"></script>
<script src="{{ asset('vendors/bootstrap-timepicker/js/bootstrap-timepicker.min.js') }}"></script>
<script src="{{ asset('vendors/daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('vendors/select2/dist/js/select2.full.min.js') }}"></script>
<script src="{{ asset('js/admin/agendamentos-atendimentos/create-show.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index') }}">Agendamentos de atendimentos</a></li>
        <li class="breadcrumb-item active" aria-current="page">Exibir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Exibir agendamento {{ $tipoAgendamento->getValue() }}
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @csrf
                @method('PUT')
                @alerts
                @endalerts

                <input type="hidden" id="hidden-route-busca" value="{{ route('admin.agendamentos-atendimentos.busca-pessoa') }}">
                <div class="form-row">
                    <div class="form-group col-2">
                        <label for="select-tipo">Tipo</label>
                        <select class="form-control" id="select-tipo" name="tipo" disabled>
                            <option value="associado" {{ $tipo == 'associado' ? 'selected' : '' }}>Associado</option>
                            <option value="funcionario" {{ $tipo == 'funcionario' ? 'selected' : '' }}>Funcionário</option>
                            <option value="dependente" {{ $tipo == 'dependente' ? 'selected' : '' }}>Dependente</option>
                        </select>
                    </div>
                    <div class="form-group col-5">
                        <label for="data_inicio_fim">Pessoa</label>
                        <input type="text" class="form-control-plaintext" readonly value="{{ $agendamento->agendavel->nome }}">
                    </div>
                    @if ($tipoAgendamento->isOdontologico())
                    <div class="form-group col-5">
                        @php
                            if ($agendamento->status->isAtendido()) {
                                $prestadorSelecionado = $agendamento->atendimento->prestadorServico;
                            } else {
                                $prestadorSelecionado = $agendamento->prestadorServico;
                            }
                        @endphp

                        <label for="prestador_servico_id">Profissional</label>
                        <select class="form-control" disabled name="prestador_servico_id">
                            @foreach ($prestadores as $prestador)
                            <option value="{{ $prestador->id }}" @if (optional($prestadorSelecionado)->id == $prestador->id) selected @endif>{{ $prestador->nome }}</option>
                            @endforeach
                        </select>
                    </div>
                    @endif
                </div>
                <div class="form-row">
                    <div class="form-group col-2">
                        <label for="data">Data</label>
                        <input type="text" autocomplete="off" readonly class="form-control-plaintext" value="{{ $agendamento->inicio->format('d/m/Y') }}">
                    </div>
                    <div class="form-group col-2">
                        <label for="hora_inicio">Hora início</label>
                        <input type="text" id="input-hora-inicio" readonly class="form-control-plaintext" value="{{ $agendamento->inicio->format('G:i') }}">
                    </div>
                    <div class="form-group col-2">
                        <label for="hora_fim">Hora fim</label>
                        <input type="text" id="input-hora-fim" name="hora_fim" readonly class="form-control-plaintext" value="{{ $agendamento->fim->format('G:i') }}">
                    </div>
                    <div class="form-group col-2">
                        <label for="emergencia">Emergência</label>
                        <input type="text" id="input-hora-fim" name="emergencia" readonly class="form-control-plaintext" value="{{ $agendamento->emergencia ? 'SIM' : 'NÃO' }}">
                    </div>
                    @if (! $agendamento->status->isAberto())
                        <div class="form-group col-4">
                            <label for="status">Status</label>
                            <input type="text" name="status" readonly class="form-control-plaintext" value="{{ $agendamento->status->getValue() }}">
                        </div>

                        @if ($agendamento->status->isDesmarcou())
                        <div class="form-group col-6">
                            <label for="motivo">Motivo cancelamento</label>
                            <input type="text" name="motivo" readonly class="form-control-plaintext" value="{{ $agendamento->motivoCancelamento->descricao }}">
                        </div>
                        <div class="form-group col-6">
                            <label for="observacao">Observação</label>
                            <input type="text" name="observacao" readonly class="form-control-plaintext" value="{{ $agendamento->observacao }}">
                        </div>
                        @endif
                    @endif
                </div>
                <hr>
                @button([
                'route' => 'admin.agendamentos-atendimentos.index',
                'routeParams' => ['tipo' => $agendamento->tipo->getName()],
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ])
                @endbutton

                @if ($tipoAgendamento->isJuridico())
                    @button([
                    'icon' => 'file-text',
                    'label' => 'Processos',
                    'class' => 'btn-primary',
                    'route' => 'admin.processos-juridicos.index',
                    'routeParams' => ['pessoa' => $agendamento->agendavel, 'tipo' => $tipo, 'agendamento' => $agendamento]
                    ])
                    @endbutton
                @endif

                @if ($agendamento->status->isAberto() || $agendamento->status->isEsperandoRecepcao())
                    @button([
                    'icon' => 'x',
                    'label' => 'Desmarcar',
                    'class' => 'btn-danger btn-desmarcar',
                    'route' => 'admin.agendamentos-atendimentos.desmarcar',
                    'routeParams' => ['agendamento' => $agendamento]
                    ])
                    @endbutton
                @endif

                @if ($agendamento->status->isAberto() || $agendamento->status->isEsperandoRecepcao())
                    @button([
                    'icon' => 'x',
                    'label' => 'Faltou',
                    'class' => 'btn-danger btn-faltou',
                    'route' => 'admin.agendamentos-atendimentos.faltou',
                    'routeParams' => ['agendamento' => $agendamento]
                    ])
                    @endbutton
                @endif
                    
                @if ($agendamento->tipo->isOdontologico())
                    @button([
                    'icon' => 'clipboard',
                    'label' => 'Atender',
                    'class' => 'btn-primary',
                    'route' => 'admin.atendimentos-odontologicos.create',
                    'routeParams' => ['agendamento' => $agendamento]
                    ])
                    @endbutton
                @endif
                
                @if ($agendamento->status->isAtendido())
                    @if ($agendamento->tipo->isOdontologico())
                        @button([
                        'icon' => 'clipboard',
                        'label' => 'Atendimento',
                        'class' => 'btn-primary',
                        'route' => 'admin.atendimentos-odontologicos.edit',
                        'routeParams' => ['agendamento' => $agendamento, 'atendimento' => $agendamento->atendimento]
                        ])
                        @endbutton
                    @else
                        @button([
                        'icon' => 'clipboard',
                        'label' => 'Atendimento',
                        'class' => 'btn-primary',
                        'route' => 'admin.atendimentos-juridicos.edit',
                        'routeParams' => ['agendamento' => $agendamento, 'atendimento' => $agendamento->atendimento, 'processo' => $agendamento->atendimento->processoJuridico]
                        ])
                        @endbutton
                    @endif
                @endif

                @if ($agendamento->status->isAberto())
                    @button([
                    'icon' => 'users',
                    'label' => 'Esperando',
                    'class' => 'btn-primary btn-esperando',
                    'route' => 'admin.agendamentos-atendimentos.esperando',
                    'routeParams' => ['agendamento' => $agendamento]
                    ])
                    @endbutton
                @endif

                @if ($agendamento->tipo->isOdontologico())
                    @button([
                    'route' => 'admin.atendimentos-odontologicos.historico',
                    'routeParams' => ['agendamento' => $agendamento],
                    'target' => '_blank',
                    'icon' => 'list',
                    'label' => 'Histórico',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton

                @endif
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-desmarcar" tabindex="-1" role="dialog">
    <form method="POST" id="form-desmarcar" action="{{ route('admin.agendamentos-atendimentos.desmarcar', ['agendamento' => $agendamento])  }}">
        @csrf
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Desmarcar agendamento</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <div class="form-row">
                        <div class="form-group col-12">
                            <label for="motivo">Motivo *</label>
                            <select name="motivo" class="form-control">
                                @foreach ($motivosCancelamento as $motivo)
                                <option value="{{ $motivo->id }}">{{ $motivo->descricao }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-12">
                            <label for="observacao">Observação</label>
                            <input type="text" maxlength=150 name="observacao" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-danger">Desmarcar</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="modal-faltou" tabindex="-1" role="dialog">
    <form method="POST" id="form-faltou" action="{{ route('admin.agendamentos-atendimentos.faltou', ['agendamento' => $agendamento])  }}">
        @csrf
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Faltou ao atendimento</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Deseja realmente marcar que a pessoa faltou ao atendimento?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="modal-esperando" tabindex="-1" role="dialog">
    <form method="POST" id="form-esperando" action="{{ route('admin.agendamentos-atendimentos.esperando', ['agendamento' => $agendamento])  }}">
        @csrf
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Paciente na sala de espera</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Deseja realmente marcar que a pessoa está na sala de espera?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>

@endsection
