@extends('layouts.admin')

@push('js')
<script src="{{ asset('vendors/moment/min/moment-with-locales.min.js') }}"></script>
<script src='{{ asset("vendors/fullcalendar/locales/pt-br.js") }}'></script>
<script src='{{ asset("vendors/fullcalendar/core.min.js") }}'></script>
<script src='{{ asset("vendors/fullcalendar/daygrid.min.js") }}'></script>
<script src='{{ asset("vendors/fullcalendar/timegrid.min.js") }}'></script>
<script src='{{ asset("vendors/fullcalendar/interaction.min.js") }}'></script>
<script src="{{ asset('js/admin/agendamentos-atendimentos/index.js') }}"></script>
@endpush

@push('css')
<link href='{{ asset("vendors/fullcalendar/core.min.css") }}' rel='stylesheet' />
<link href='{{ asset("vendors/fullcalendar/daygrid.min.css") }}' rel='stylesheet' />
<link href='{{ asset("vendors/fullcalendar/timegrid.min.css") }}' rel='stylesheet' />
@endpush
@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Agendamentos de atendimentos</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Agendamentos de atendimentos
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <input type="hidden" id="hidden-event-source" value="{{ route('admin.agendamentos-atendimentos.load', ['tipo' => $tipo->getName()]) }}">
                <input type="hidden" id="hidden-route-incluir" value="{{ route('admin.agendamentos-atendimentos.create', ['tipo' => $tipo->getName()]) }}">
                <input type="hidden" id="hidden-route-obtem-data-indisponivel" value="{{ route('admin.agendamentos-atendimentos.obtem-data-indisponivel') }}">
                <input type="hidden" id="hidden-tempo-refresh" value="{{ config('app.tempo-refresh-calendario-agendamento') }}">
                <input type="hidden" id="hidden-feriados" value="{{ $feriados }}">

                @if ($tipo->isOdontologico())
                <div class="form-group row">
                    <label for="inputEmail3" class="col-form-label col-1">Prestador</label>
                    <select id="select-prestador" class="form-control col-4">
                        <option value="">TODOS</option>
                        @foreach ($prestadores as $prestador)
                            <option value="{{ $prestador->id }}">{{ $prestador->nome }}</option>
                        @endforeach
                    </select>
                </div>
                @else
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" checked id="check-faltosos-desmarcados">
                    <label class="form-check-label" for="check-faltosos-desmarcados">
                        Ocultar Faltosos e Desmarcados
                    </label>
                </div>
                @endif

                <div class="mt-3" id="calendario"></div>
            </section>
        </div>
    </div>
</div>
@endsection