@extends('layouts.admin')

@push('css')
<link href="{{ asset('vendors/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('css/admin/agendamentos-atendimentos-create-show.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('vendors/select2/dist/js/select2.full.min.js') }}"></script>
<script src="{{ asset('js/admin/agendamentos-atendimentos/busca.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => strtolower($tipo->getName())]) }}">Agendamentos de atendimentos</a></li>
        <li class="breadcrumb-item active" aria-current="page">Busca</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Buscar agendamento {{ mb_strtolower($tipo->getValue()) }}
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form id="form-busca" action="{{ route('admin.agendamentos-atendimentos.busca') }}" method="get">
                    @alerts
                    @endalerts

                    <input type="hidden" id="hidden-route-busca" value="{{ route('admin.agendamentos-atendimentos.busca-pessoa') }}">
                    <input type="hidden" id="hidden-route-busca-tipo-id" value="{{ url('admin/agendamentos-atendimentos/busca-pessoa/') }}">
                    <input type="hidden" id="hidden-pessoa-selecionada-anteriormente" value="{{ request()->pessoa }}">
                    <input type="hidden" name="tipo" value="{{ $tipo->getName() }}">

                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="select-tipo">Tipo</label>
                            <select autofocus class="form-control" id="select-tipo" name="tipo_pessoa">
                                <option value="associado" {{ request()->tipo_pessoa == 'associado' ? 'selected' : '' }}>Associado</option>
                                <option value="funcionario" {{ request()->tipo_pessoa == 'funcionario' ? 'selected' : '' }}>Funcionário</option>
                                <option value="dependente" {{ request()->tipo_pessoa == 'dependente' ? 'selected' : '' }}>Dependente</option>
                            </select>
                        </div>
                        <div class="form-group col-5">
                            <label for="pessoa">Pessoa</label>
                            <select required name="pessoa" id="select-pessoa" class="form-control @error('pessoa') is-invalid @enderror"></select>
                        </div>
                        <div class="form-inline mt-3">
                            <button class="btn btn-outline-primary" type="submit">Filtrar</button>
                            <button id="btn-limpar" class="btn btn-outline-secondary mx-1" type="button" form="filtro">Limpar</button>
                        </div>
                    </div>
                    <hr>
                </form>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Data/Horário</th>
                            @if ($tipo->isOdontologico())<th>Prestador</th>@endif
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($agendamentos as $agendamento)
                        <tr>
                            <td>{{ $agendamento->inicio->format('d/m/Y H:i') }} - {{ $agendamento->fim->format('H:i') }}</td>
                            @if ($tipo->isOdontologico())<td> {{ $agendamento->prestadorServico->nome }}</td>@endif
                            <td>
                                @button([
                                    'route' => 'admin.agendamentos-atendimentos.show',
                                    'routeParams' => ['agendamento' => $agendamento],
                                    'class' => 'btn-primary',
                                    'label' => 'Visualizar/Editar',
                                    'icon' => 'edit'
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-sucesso" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <p>{{ session('status') }}</p>
                <p class="mt-2">Paciente não tem anamnese, deseja preencher agora?</p>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-criar-anamnese" data-url="{{ url('admin/agendamentos-atendimentos/atendimentos-odontologicos/anamnese/') }}" class="btn btn-primary">Sim</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <p>{{ session('exceptionMessage') }}</p>
                <p class="mt-2">Deseja continuar e agendar o atendimento mesmo assim?</p>
            </div>
            <div class="modal-footer">
                <button type="submit" form="form-agendamento" class="btn btn-primary">Sim</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
            </div>
        </div>
    </div>
</div>
@endsection