@extends('layouts.admin')

@push('css')
<link href="{{ asset('vendors/daterangepicker/daterangepicker.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('vendors/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('css/admin/agenda-diretoria-create-edit.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('vendors/moment/min/moment-with-locales.min.js') }}"></script>
<script src="{{ asset('vendors/daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('vendors/select2/dist/js/select2.full.min.js') }}"></script>
<script src="{{ asset('js/admin/agenda-diretoria/create-edit.js') }}"></script>
@endpush


@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agenda-diretoria.index') }}">Agenda da diretoria</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar evento
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.agenda-diretoria.update', ['evento' => $evento->id]) }}" method="post">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-8">
                            <label for="titulo">Título *</label>
                            <input type="text" autofocus required name="titulo" maxlength="100" class="form-control @error('titulo') is-invalid @enderror" value="{{ $evento->titulo }}">
                        </div>
                        <div class="form-group col-4">
                            <label for="data_inicio_fim">Data *</label>
                            <input type="text" autocomplete="off" name="data_inicio_fim" maxlength="10" class="form-control data @error('data_inicio_fim') is-invalid @enderror" value="{{ $evento->data }}">
                        </div>
                        <div class="form-group col-6">
                            <label for="descricao">Descrição</label>
                            <input type="text" name="descricao" maxlength="255" class="form-control @error('descricao') is-invalid @enderror" value="{{ $evento->descricao }}">
                        </div>
                        <div class="form-group col-6">
                            <label for="local">Local</label>
                            <input type="text" name="local" maxlength="50" class="form-control @error('local') is-invalid @enderror" value="{{ $evento->local }}">
                        </div>
                        <div class="form-group col-6">
                            <label for="convidados">Convidados</label>
                            <select name="convidados[]" class="form-control" id="select-convidados" multiple="multiple">
                                @foreach ($evento->convidados as $convidado)
                                    <option value="{{ $convidado }}">{{ $convidado }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'class' => 'btn-danger btn-excluir',
                    'icon' => 'x',
                    'label' => 'Excluir',
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.agenda-diretoria.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir" tabindex="-1" role="dialog">
    <form method="POST" action="{{ route('admin.agenda-diretoria.destroy', ['evento' => $evento->id]) }}">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o evento?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection