document.addEventListener('DOMContentLoaded', function () {
    moment.locale('pt-br');
    var calendarEl = document.getElementById('calendario');
    var hora = '';
    var extraParams = {};
    var tempoRefreshCalendar = $('#hidden-tempo-refresh').val(); 
    
    if ($('#select-prestador').val() != undefined) {
        extraParams = {
            prestador: $('#select-prestador').val()
        }
    }

    if ($('#check-faltosos-desmarcados').val() != undefined) {
        extraParams = {
            ocultarFaltososDesmarcados: $('#check-faltosos-desmarcados').prop('checked')
        }
    }

    function finsDeSemanaEFeriados() {
        let cor = "#ff9f89";

        var finsDeSemanaEFeriados = [{
            daysOfWeek: [0, 6], // Domingos e sábados
            rendering: "background",
            color: cor,
        }];

        var feriados = JSON.parse($('#hidden-feriados').val());

        for (var feriado of feriados) {
            var dataInicio = moment(feriado.data_inicio, 'DD/MM/YYYY').format('YYYY-MM-DD');
            var dataFim = moment(feriado.data_fim, 'DD/MM/YYYY').format('YYYY-MM-DD');
            finsDeSemanaEFeriados.push({
                rendering: "background",
                color: cor,
                start: dataInicio,
                end: dataFim,
            });
        }

        return finsDeSemanaEFeriados;
    }

    var calendar = new FullCalendar.Calendar(calendarEl, {
        plugins: ['dayGrid', 'timeGrid', 'interaction'],
        timeZone: 'UTC',
        defaultView: 'timeGridDay',
        selectable: true,
        minTime: '08:00',
        maxTime: '18:00',
        slotLabelInterval: '00:30',
        slotLabelFormat: {
            omitZeroMinute: false,
            hour: 'numeric',
            minute: '2-digit',
            meridiem: 'short'
        },
        customButtons: {
            incluir: {
                text: 'Incluir',
                click: function () {
                    var data = moment.parseZone(calendar.getDate().toISOString()).format('DD/MM/YYYY');
                    var rota = $('#hidden-route-incluir').val();
                    rota += '&data=' + encodeURIComponent(data);

                    if ($('#select-prestador').val()) {
                        rota += '&prestador=' + encodeURIComponent($('#select-prestador').val());
                    }

                    if (hora) {
                        rota += '&hora=' + encodeURIComponent(hora)
                    }

                    top.location = rota
                }
            }
        },
        select: function (info) {
            data = moment.parseZone(info.startStr).format('DD/MM/YYYY');
            hora = moment.parseZone(info.startStr).format('HH:mm');
        },
        header: {
            left: 'prev,next today incluir',
            center: 'title',
            right: 'timeGridDay,timeGridWeek,dayGridMonth'
        },
        eventSources: [
            {
                id: 1,
                url: document.getElementById('hidden-event-source').value,
                method: 'GET',
                extraParams: extraParams
            },
        ],
        events: finsDeSemanaEFeriados()
    });

    calendar.setOption('locale', 'pt-br');
    calendar.render();

    $('#select-prestador').change(function () {
        calendar.getEventSourceById(1).remove();
        calendar.addEventSource({
            id: 1,
            url: document.getElementById('hidden-event-source').value,
            method: 'GET',
            extraParams: {
                prestador: $('#select-prestador').val()
            }
        });
    });

    $('#check-faltosos-desmarcados').change(function () {
        calendar.getEventSourceById(1).remove();
        calendar.addEventSource({
            id: 1,
            url: document.getElementById('hidden-event-source').value,
            method: 'GET',
            extraParams: {
                ocultarFaltososDesmarcados: $('#check-faltosos-desmarcados').prop('checked')
            }
        });
    });

    setInterval(function () { 
        calendar.refetchEvents();
    }, tempoRefreshCalendar);
});

