$(function () {
    moment.locale('pt-br');

    $('#modal-desmarcar, #modal-faltou, #modal-esperando, #modal-pergunta, #modal-agendamento-extraordinario').modal({
        'show': false
    });

    $('#select-pessoa').select2({
        ajax: {
            url: $('#hidden-route-busca').val(),
            dataType: 'json',
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page,
                    tipo: $('#select-tipo').val()
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        },
        minimumInputLength: 3,
        language: {
            inputTooShort: function () {
                return "Digite 3 ou mais caracteres para buscar a pessoa";
            }
        }
    });

    if ($('#hidden-pessoa-selecionada-anteriormente').val()) {
        // Se der erro de validação, obtém a pessoa que foi tentada agendar o atendimento
        // e monta o select2

        var selectPessoa = $('#select-pessoa');
        $.ajax({
            type: 'GET',
            url: $('#hidden-route-busca-tipo-id').val() + '/' + $('#select-tipo').val() + '/' + $('#hidden-pessoa-selecionada-anteriormente').val()
        }).then(function (data) {
            var option = new Option(data.nome, data.id, true, true);
            selectPessoa.append(option).trigger('change');

            selectPessoa.trigger({
                type: 'select2:select',
                data: {
                    data: data
                }
            });
        });
    }

    $(document).on('focus', '.select2.select2-container', function (e) {
        if (e.originalEvent && $(this).find(".select2-selection--single").length > 0) {
            $(this).siblings('select').select2('open');
        }
    });

    $('.data').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minDate: moment(),
        locale: {
            format: 'DD/MM/YYYY'
        },
        isInvalidDate: function (date) {
            fimDeSemana = date.day() == 0 || date.day() == 6;
            return fimDeSemana || eFeriado(date);
        }
    });

    function eFeriado(dia) {
        var feriados = JSON.parse($('#hidden-feriados').val());
        
        for (var feriado of feriados) {
            var dataInicio = moment(feriado.data_inicio, 'DD/MM/YYYY');
            var dataFim = moment(feriado.data_fim, 'DD/MM/YYYY');

            if (moment(dia).isSameOrAfter(dataInicio) && moment(dia).isSameOrBefore(dataFim)) {
                return true;
            }
        };

        return false;
    }

    $('.hora').timepicker({
        minuteStep: 30,
        template: false,
        showMeridian: false,
        defaultTime: false,
    });

    $('#input-hora-inicio').blur(function() {
        if ($(this).val() && ! $('#input-hora-fim').val()) {
            var hora = moment($(this).val(), 'HH:mm').add(30, 'm').format('HH:mm');
            $('#input-hora-fim').timepicker('setTime', hora);
        }
    });

    $('.btn-desmarcar').click(function (e) {
        e.preventDefault();
        $('#modal-desmarcar').modal('show');
    });

    $('.btn-faltou').click(function (e) {
        e.preventDefault();
        $('#modal-faltou').modal('show');
    });

    $('.btn-esperando').click(function (e) {
        e.preventDefault();
        $('#modal-esperando').modal('show');
    });

    $('#modal-sucesso').modal({
        'show': false
    });

    if ($('#hidden-pessoa-sem-anamnese').val()) {
        $('#modal-sucesso').modal('show');
    }

    $('#btn-criar-anamnese').click(function() {
        var pessoa = $('#hidden-pessoa-recem-agendada').val();
        var tipo = $('#hidden-tipo-pessoa-recem-agendada').val();
        var ultimoAgendamento = $('#hidden-agendamento-recem-criado').val();
        
        top.location = $(this).attr('data-url') + "/" + pessoa + "/tipo/" + tipo + "/create-edit?agendamento=" + ultimoAgendamento;
        
    });

    $('#select-tipo').change(function() {
        $('#select-pessoa').val(null).trigger('change');
    });

    if ($('#hidden-emergencia').val() == "1" || $('#hidden-em-tratamento').val() == "1" || $('#hidden-ultimo-atendimento-proximo').val() == "1") {
        $('#modal-pergunta').modal('show');
    }

    if ($('#hidden-extraordinario').val() == "1") {
        $('#modal-agendamento-extraordinario').modal('show');
        $('#text-motivo-extraordinario').prop('required', true);
    }

    $('#btnCancelarAgendamentoExtraordinario').click(function() {
        $('#text-motivo-extraordinario').prop('required', false);
        $('#hidden-extraordinario').val('0');
    });
});