$(function () {
    $('#select-pessoa').select2({
        ajax: {
            url: $('#hidden-route-busca').val(),
            dataType: 'json',
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page,
                    tipo: $('#select-tipo').val()
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        },
        minimumInputLength: 3,
        language: {
            inputTooShort: function () {
                return "Digite 3 ou mais caracteres para buscar a pessoa";
            }
        }
    });

    if ($('#hidden-pessoa-selecionada-anteriormente').val()) {
        // Se der erro de validação, obtém a pessoa que foi tentada agendar o atendimento
        // e monta o select2

        var selectPessoa = $('#select-pessoa');
        $.ajax({
            type: 'GET',
            url: $('#hidden-route-busca-tipo-id').val() + '/' + $('#select-tipo').val() + '/' + $('#hidden-pessoa-selecionada-anteriormente').val()
        }).then(function (data) {
            var option = new Option(data.nome, data.id, true, true);
            selectPessoa.append(option).trigger('change');

            selectPessoa.trigger({
                type: 'select2:select',
                data: {
                    data: data
                }
            });
        });
    }

    $(document).on('focus', '.select2.select2-container', function (e) {
        if (e.originalEvent && $(this).find(".select2-selection--single").length > 0) {
            $(this).siblings('select').select2('open');
        }
    });
});