document.addEventListener('DOMContentLoaded', function () {
    var calendarEl = document.getElementById('calendario');

    var calendar = new FullCalendar.Calendar(calendarEl, {
        plugins: ['dayGrid'],
        eventSources: [
            {
                id: 'diretoria',
                url: document.getElementById('hidden-event-source-diretoria').value,
                method: 'GET',
                failure: function (error) {
                    $('#alert-erro-carregamento')
                        .html(JSON.parse(error.xhr.response).erro)
                        .removeClass('d-none');
                },
            },
        ]
    });

    calendar.setOption('locale', 'pt-br');
    calendar.render();

    $('#check-feriados').change(function() {
        if (this.checked) {
            calendar.addEventSource({
                id: 'feriados',
                url: document.getElementById('hidden-event-source-feriados').value,
                backgroundColor: '#FFC107',
                borderColor: '#FFC107'
            });
        } else {
            calendar.getEventSourceById('feriados').remove();
        }

        return true;
    });

    $('#check-diretoria').change(function() {
        if (this.checked) {
            calendar.addEventSource({
                id: 'diretoria',
                url: document.getElementById('hidden-event-source-diretoria').value,
            });
        } else {
            calendar.getEventSourceById('diretoria').remove();
        }

        return true;
    });
});