<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterRegistrosServidoresAddFkNivelSalarial extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('registros_servidores', function (Blueprint $table) {
            $table->smallInteger('nivel_salarial_id')->nullable();
            $table->foreign('nivel_salarial_id')->references('id')->on('niveis_salariais');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('registros_servidores', function (Blueprint $table) {
            $table->dropForeign(['nivel_salarial_id']);
            $table->dropColumn('nivel_salarial_id');
        });
    }
}
