<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterRegistrosAtendimentosAddFkMotivoRegistro extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('registros_atendimentos', function (Blueprint $table) {
            $table->smallInteger('motivo_id')->nullable();
            $table->foreign('motivo_id')
                  ->references('id')
                  ->on('motivos_registro_atendimento');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('registros_atendimentos', function (Blueprint $table) {
            $table->dropForeign(['motivo_id']);
            $table->dropColumn('motivo_id');
        });
    }
}
