<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterCargosModifyNivelSalarial extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cargos', function (Blueprint $table) {
            $table->renameColumn('nivel_salarial', 'nivel_salarial_id');
        });

        Schema::table('cargos', function (Blueprint $table) {
            $table->foreign('nivel_salarial_id')->references('id')->on('niveis_salariais');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cargos', function (Blueprint $table) {
            $table->dropForeign(['nivel_salarial_id']);
        });
    }
}
