<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class DropMovimentosCaixa extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('movimentos_caixa');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::create('movimentos_caixa', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('descricao', 100);
            $table->string('complemento', 150)->nullable();
            $table->date('data_lancamento');
            $table->bigInteger('conta_a_pagar_id')->nullable();
            $table->smallInteger('tipo_movimento'); // TipoMovimentoCaixaEnum
            $table->decimal('valor');
            $table->bigInteger('caixa_id')->default(1);
            $table->foreign('caixa_id')
                ->references('id')
                ->on('caixas');
            $table->timestamps();
        });
        
        Schema::table('movimentos_caixa', function (Blueprint $table) {
            $table->index(['conta_a_pagar_id', 'data_lancamento', 'tipo_movimento']);
        });
    }
}
