<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterContasPagarReceberAddClassificacaoConta extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('contas_pagar_receber', function (Blueprint $table) {
            $table->unsignedBigInteger('classificacao_conta_id')
            ->constrained()
            ->onDelete('set null')
            ->onUpdate('cascade')
            ->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('contas_pagar_receber', function (Blueprint $table) {
            $table->dropForeign('classificacao_conta_id_foreign');
        });
    }
}
