<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterContasPagarReceberAddCampos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('contas_pagar_receber', function (Blueprint $table) {
            $table->string('numero_documento')->nullable();
            $table->smallInteger('forma_pagamento')->nullable(); // FormaPagamentoContaPagarEnum
            $table->smallInteger('recorrencia')->nullable(); // RecorrenciaContaPagaReceberEnum
            $table->smallInteger('tipo_despesa')->nullable(); // TipoDespesaContaPagarReceberEnum
            $table->smallInteger('tipo')->nullable(); // TipoContaPagarReceberEnum
            $table->string('responsavel_despesa', 100)->nullable();
            $table->string('observacoes')->nullable();
            $table->string('caminho_documento')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('contas_pagar_receber', function (Blueprint $table) {
            $table->dropColumn('numero_documento', 'forma_pagamento', 'tipo', 'recorrencia', 'tipo_despesa', 'responsavel_despesa', 'observacoes', 'caminho_documento');
        });
    }
}
