<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterRegistrosServidoresAddCamposAposentado extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('registros_servidores', function (Blueprint $table) {
            $table->date('data_aposentadoria')->nullable();
            $table->boolean('paridade')->nullable();
            $table->smallInteger('proventos')->nullable(); // ProventoAposentadoEnum
            $table->smallInteger('tipo_aposentadoria')->nullable(); // TipoAposentadoria
            $table->string('portaria_aposentadoria', '20')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('registros_servidores', function (Blueprint $table) {
            $table->dropColumn('data_aposentadoria', 'paridade', 'proventos', 'tipo_aposentadoria', 'portaria_aposentadoria');
        });
    }
}
