<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAnexosProcessosJuridicosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('anexos_processos_juridicos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('processo_juridico_id');
            $table->foreign('processo_juridico_id')
                    ->references('id')
                    ->on('processos_juridicos');
            $table->string('descricao', 50);
            $table->string('caminho', 150);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('anexos_processos_juridicos');
    }
}
