<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProcessosJuridicosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('processos_juridicos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('numero', 10);
            $table->string('vara', 10);
            $table->bigInteger('agendavel_id');
            $table->string('agendavel_type');
            $table->bigInteger('competencia_id');
            $table->foreign('competencia_id')
                    ->references('id')
                    ->on('competencias_processos');
            $table->bigInteger('tipo_acao_id');
            $table->foreign('tipo_acao_id')
                    ->references('id')
                    ->on('competencias_processos');
            $table->boolean('extinto');
            $table->smallInteger('resultado'); // ResultadoProcessoJuridicoEnum
            $table->text('anotacoes');
            $table->double('valor_pago');
            $table->date('data_pagamento');
            $table->boolean('pago');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('processos_juridicos');
    }
}
