<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterRegistrosServidoresSomenteNumeroNotNull extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('registros_servidores', function (Blueprint $table) {
            $table->date('data_admissao')->nullable()->change();
            $table->integer('cargo_id')->nullable()->change();
            $table->boolean('readaptado')->nullable()->change();
            $table->integer('unidadeorganizacional_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('registros_servidores', function (Blueprint $table) {
            $table->date('data_admissao')->nullable(false)->change();
            $table->integer('cargo_id')->nullable(false)->change();
            $table->boolean('readaptado')->nullable(false)->change();
            $table->integer('unidadeorganizacional_id')->nullable(false)->change();
        });
    }
}
