<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRegistrosAtendimentosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('registros_atendimentos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->text('atendimento');
            $table->bigInteger('user_id');
            $table->foreign('user_id')
                ->references('id')
                ->on('users');
            $table->bigInteger('servidor_id');
            $table->foreign('servidor_id')
                ->references('id')
                ->on('servidores');
            $table->boolean('resolvido');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('registros_atendimentos');
    }
}
