<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterRespostasAnamneseAddRespostaQual extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('respostas_anamnese', function (Blueprint $table) {
            $table->dropColumn('resposta');
        });

        Schema::table('respostas_anamnese', function (Blueprint $table) {
            $table->boolean('resposta')->default(false);
            $table->string('qual')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('respostas_anamnese', function (Blueprint $table) {
            $table->dropColumn('resposta');
            $table->dropColumn('qual');
        });

        Schema::table('respostas_anamnese', function (Blueprint $table) {
            $table->string('resposta', 300);
        });
    }
}
