<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRespostasAnamneseTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('respostas_anamnese', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('agendamento_atendimento_id')->nullable();
            $table->foreign('agendamento_atendimento_id')
                ->references('id')
                ->on('agendamentos_atendimentos');
            $table->bigInteger('pergunta_anamnese_id')->nullable();
            $table->foreign('pergunta_anamnese_id')
                ->references('id')
                ->on('perguntas_anamnese');
            $table->string('resposta', 300);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('respostas_anamnese');
    }
}
