<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterAgendamentosAtendimentosAddPrestadorServicoIdStatus extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('agendamentos_atendimentos', function (Blueprint $table) {
            $table->bigInteger('prestador_servico_id')->nullable();
            $table->foreign('prestador_servico_id')
            ->references('id')
            ->on('prestadores_servicos');
            $table->smallInteger('status')->nullable(); // StatusAgendamentoAtendimentoEnum
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('agendamentos_atendimentos', function (Blueprint $table) {
            $table->dropColumn('prestador_servico_id');
            $table->dropColumn('status');
        });
    }
}
