<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMovimentacoesServidoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('movimentacoes_servidores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('servidor_id');
            $table->foreign('servidor_id')
                    ->references('id')
                    ->on('servidores');
            $table->bigInteger('registro_id')->nullable();
            $table->foreign('registro_id')
                ->references('id')
                ->on('registros_servidores');
            $table->string('descricao');
            $table->json('payload')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('movimentacoes_servidores');
    }
}
