<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterServidoresAddNacionalidadeFlagNaoPerturbe extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('servidores', function (Blueprint $table) {
            $table->string('nacionalidade', 150);
            $table->boolean('nao_perturbe')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('servidores', function (Blueprint $table) {
            $table->dropColumn('nacionalidade');
            $table->dropColumn('nao_perturbe');
        });
    }
}
